/*************************************************/
/* Examples Program For "ET-dsPIC30F2010"  Board */
/* Hardware    : ET-dsPIC30F2010 TRAINING KIT V1 */
/* Target MCU  : dsPIC30F2010                    */
/*       	   : X-TAL : 7.3728 MHz              */
/*             : Run 117.9648MHz                 */
/*             : Selec OSC Mode = XT w/PLL 16x   */
/* Compiler    : MPLAB + C30 V1.33  		     */
/* Last Update : 1/October/2005                  */
/* Function    : Example Use RB on Output Mode   */
/*             : LED Moving on RB[0..3]          */	
/*************************************************/

#include "p30f2010a2.h"	                                	// dsPIC30F2010 MPU Register

/* Setup Configuration For ET-dsPIC30F2010 */
_FOSC(CSW_FSCM_ON & XT_PLL16);								// Enable Clock Switching,Enable Fail-Salf Clock
                                                            // Closk Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_ON & BORV_45 & PWRT_64 & MCLR_EN);			// Enable Brown-Out = 4.5V,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End   Configuration For ET-dsPIC30F2010 */

/* pototype  section */
void delay_led(unsigned long int);							// Delay Time Function

int main(void)
{  
  unsigned char LED;

  TRISBbits.TRISB0 = 0;										// Config RB0 = Output
  TRISBbits.TRISB1 = 0;										// Config RB1 = Output
  TRISBbits.TRISB2 = 0;										// Config RB2 = Output
  TRISBbits.TRISB3 = 0;										// Config RB3 = Output
  
  // Loop Moving LED on RB[0..3] //
  while(1)													// Loop Continue
  {     	
    // RB3 <-- RB0
    for (LED = 0x01; LED < 0x08; LED <<= 1)					// Shift Left LED Output (Right <- Left)
    { 
      LATB = 0xFF-LED;	  									// Toggle Active PORTB[0..3] Output
      delay_led(1500000);									// Display Delay	 
    }  
	  	
	// RB3 ---> RB0
	for (LED = 0x08; LED > 0x01; LED >>= 1)					// Shift Right LED Output(Right -> Left)
    { 
      LATB = 0xFF-LED;										// Toggle Active PORTB[0..3] Output
      delay_led(1500000);									// Display Delay
    }  	 	  	 
  }   
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay_led(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}
